/*jshint esversion: 6 */

define(["lib/dev/config", "lib/dev/internal"], function(devConfig, internal) {

"use strict";

function callsiteWarning (fn, format) {
	var message = internal.sprintf("Warning: " + format, arguments, 2);

	// get info on call site
	var e = new Error(message);
	Error.captureStackTrace(e, fn);
	console.log(e.stack.substring(7));
}

function deprecated(nameDeprecated, nameReplacement, fnReplacement) {
	if (devConfig.Debug.enabled) {
		var warned = false;

		var fn = function () {
			if ( !warned ) {
				callsiteWarning(fn, "'%s' is deprecated. Use '%s' instead.", nameDeprecated, nameReplacement);
				warned = true;
			}

			return fnReplacement.apply(this, arguments);
		};

		return fn;
	} else {
		return fnReplacement;
	}
}

return deprecated;

}); // end define